/**************************************************************************************
 
   Copyright (c) Hilscher GmbH. All Rights Reserved.
 
 **************************************************************************************
 
   Filename:
    $Workfile: MailboxStateDlg.cpp $
   Last Modification:
    $Author: MichaelT $
    $Modtime: 5.07.06 9:40 $
    $Revision: 1353 $
   
   Targets:
     Win32/ANSI   : yes
     Win32/Unicode: yes (define _UNICODE)
     WinCE        : no
 
   Description:
    Mailbox State Dialog
       
   Changes:
 
     Version   Date        Author   Description
     ----------------------------------------------------------------------------------
      1        05.07.2006  MT       initial version

 
**************************************************************************************/

///////////////////////////////////////////////////////////////////////////////////////////
/// \file MailboxStateDlg.cpp
/// Mailbox State Dialog
///////////////////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "cifXTest.h"
#include "MailboxStateDlg.h"
#include "CifXTestDlg.h"


// CMailboxStateDlg dialog

IMPLEMENT_DYNAMIC(CMailboxStateDlg, CBaseDialog)

/////////////////////////////////////////////////////////////////////////////
/// Default Constructor
///   \param pParent Parent Window
/////////////////////////////////////////////////////////////////////////////
CMailboxStateDlg::CMailboxStateDlg(CWnd* pParent /*=NULL*/)
	: CBaseDialog(CMailboxStateDlg::IDD, pParent, false)
{
}

/////////////////////////////////////////////////////////////////////////////
/// Destructor
/////////////////////////////////////////////////////////////////////////////
CMailboxStateDlg::~CMailboxStateDlg()
{
}

/////////////////////////////////////////////////////////////////////////////
/// DDX/DDV support
///   \param pDX 
/////////////////////////////////////////////////////////////////////////////
void CMailboxStateDlg::DoDataExchange(CDataExchange* pDX)
{
	CBaseDialog::DoDataExchange(pDX);
}


BEGIN_MESSAGE_MAP(CMailboxStateDlg, CBaseDialog)
  ON_BN_CLICKED(IDC_BTN_UPDATE, OnBnClickedBtnUpdate)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
/// Cyclic Thread function (unused)
/////////////////////////////////////////////////////////////////////////////
void CMailboxStateDlg::ThreadFunction()
{
  //Do nothing here, as we dont have anything to do cyclically
}

/////////////////////////////////////////////////////////////////////////////
/// Device change notification from main dialog
///   \param pcDevice NULL if device was closed, else the newly selected device
/////////////////////////////////////////////////////////////////////////////
void CMailboxStateDlg::OnUpdateDevice(CCifXDeviceBase* pcDevice)
{
  if(NULL != pcDevice)
  {
    OnBnClickedBtnUpdate();
  }
}

/////////////////////////////////////////////////////////////////////////////
/// Update button clicked event. Requeries the Mailbox state and updates 
/// window content.
/////////////////////////////////////////////////////////////////////////////
void CMailboxStateDlg::OnBnClickedBtnUpdate()
{
  if(CcifXTestDlg::s_pcDevice)
  {
    uint32_t ulRecvCount = 0;
    uint32_t ulSendCount = 0;

    long lRet = CcifXTestDlg::s_pcDevice->GetMBXState(&ulRecvCount, &ulSendCount);

    SetDlgItemInt(IDC_EDT_PENDRECV, ulRecvCount, FALSE);
    SetDlgItemInt(IDC_EDT_MAXSEND,  ulSendCount, FALSE);

    CString csError;
    if(CIFX_NO_ERROR != lRet)
    {
      csError.Format(_T("0x%08X\r\n%s"), 
                     lRet,
                     (LPCTSTR)CcifXTestDlg::s_pcDevice->GetErrorDescription(lRet));

    }
    SetDlgItemText(IDC_LASTERR, csError);
  }
}
